package Worm;

our(@ISA, @EXPORT, @EXPORT_OK);

use strict;
use Exporter;

@ISA = ('Exporter');
@EXPORT_OK = qw( Wormbase_url Proteome_url
	);

@EXPORT = qw( No_splice
	);


#use CGI qw/:standard :html3/;

#---------------------------
#Written by Jim Lund, Department of Biology, University of Kentucky.
#jiml@uky.edu
#
#Web site: http://elegans.uky.edu
#---------------------------
#
#Created: 7-05
#Last Modified: 7-22-05
#Version: .001
#
#HISTORY
#
#v.001, 7-22-05
#-Added No_splice.
#




#
#Worm specific functions.
#


############################################################################
#Calls: none
#
#Input: gene name
#Output: Gene name with splice form removed.
#
sub No_splice {
my ($gene) = @_;

$gene =~ s/(\.\d+)[a-z]+$/$1/i;

return $gene;
}


###########################################################################
#Input: Gene cosmid name
#
#Output: HTML with link to Wormbase entry for this gene.
#
sub Wormbase_url {
my ($gene,$class,$annote_len,$show) = @_;

use WebConfig;
WebConfig::CGI_init;

use vars qw( $wormbase_base_url );

if (!$class) { $class = 'Predicted_Gene'; }
if (!$show) { $show = $gene; }

my $gene_url=$gene;
$gene_url=~ s/([^a-zA-Z0-9\.\*\_\-])/'%'.sprintf("%X",ord($1))/ge;
$gene_url=~ s/ /+/g;

$gene_url=$wormbase_base_url.$gene_url.";class=$class";

$gene_url="<A HREF='$gene_url'>$show</A>";

$annote_len+=length($gene_url)-length($gene);

return ($gene_url,$annote_len);
}



############################################################################
#Input: Gene cosmid name
#
#Output: HTML with link to Proteome/Incyte entry for this gene.
#
sub Proteome_url {
my ($gene,$annote_len,$show) = @_;

use WebConfig;
WebConfig::CGI_init;

use vars qw( $proteome_base_url );

if (!$show) { $show = $gene; }

my $gene_url=$gene;
$gene_url=~ s/([^a-zA-Z0-9\.\*\_\-])/'%'.sprintf("%X",ord($1))/ge;
$gene_url=~ s/ /+/g;

$gene_url=$proteome_base_url.$gene_url.'.html';

$gene_url="<A HREF='$gene_url'>$show</A>";

$annote_len+=length($gene_url)-length($gene);

return ($gene_url,$annote_len);
}




1;
