#
#Create Oracle tables used by compare_genes.cgi
#
#Copyright (C) 2005  Jim Lund
#---------------------------
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#---------------------------
#Version: 0.001
#
#Last modified:  8-05
#Written by Jim Lund, Department of Biology, University of Kentucky.
#jiml at uky dot edu
#Web site: http://elegans.uky.edu
#

use gl;

DROP TABLE genes_map;

CREATE TABLE genes_map (gene_cos_name VARCHAR2(50) NOT NULL, gene VARCHAR2(100), chromosome VARCHAR2(20), strand INT, bp_start INT, bp_end INT, modified DATE);

CREATE index NDX_gm_gene_cos_name on genes_map(gene_cos_name);
CREATE index NDX_gm_gene on genes_map(gene);



DROP TABLE IF EXISTS sjj_primers;

CREATE TABLE sjj_primers (gene_name_key int unique not null, primerL VARCHAR2(30), tm_left int, primerR VARCHAR2(30), tm_right int, product_length int, bases_coding int, quality decimal(10,5), modified DATE);

CREATE index NDX_pr_g_n_key on primers(gene_name_key)


